unit fVimm;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls,
   mVimMBase, mVimmSelect, mVimmGrid, mVimmEdit, mVimmICE, rVimm, ORFn, rMisc;

type
  TvimmMainForm = class(TForm)
    Panel1: TPanel;
    btnCancel: TButton;
    GridPanel: TGridPanel;
    btnSave: TButton;
    procedure btnCancelClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    encDate:  TFMDateTime;
    encLoc:   string;
    encType:  string;
    userIEN:  string;
    userName:   string;
    patientIEN: string;
    patientName: string;
    encProvIEN:   string;
    encProvName:  string;
    visitString: string;
    initialList:  TStringList;
    noGrid: boolean;
    collapseICE: boolean;
    canSaveData: boolean;
    makeNote: boolean;
    documentType: string;
    noteString: string;
    function validateInput(inputList: TStringList): boolean;
    procedure createGridPanel;
    procedure setInitialGridValues;
    procedure disableButtons;
  public
    { Public declarations }
  end;

  function performVimm(inputList: TStringList; var resultList: TStringList; saveData: boolean = false): boolean;
var
  vimmMainForm: TvimmMainForm;

implementation
var
frmICE, frmGrid, frmImm, frmImmEdit: TFrame;

{$R *.dfm}
// possible inputs and recommended settings
     //reminders for a single finding
     //NoGrid = true
     //collapseICE = true
     //makeNote = false
     //canSaveData = false
     //
     //reminders for a new generic finding
     //NoGrid = false
     //collapseICE = false
     //makeNote = false
     //canSaveData = false
     //
     //coversheet
     //NoGrid = false
     //collapseICE = false
     //makeNote = true
     //canSaveData = true
     //
     //BCMA
     //NoGrid - true
     //collapseICE = true
     //makeNote = true
     //canSaveData = true


function performVimm(inputList: TStringList; var resultList: TStringList; saveData: boolean = false): boolean;
begin
  try
    result := false;
    if not assigned(vimmMainForm) then vimmMainForm := TVimmMainForm.Create(Application);
    if not vimmMainForm.validateInput(inputList) then
      begin
        exit;
      end;
    vimmMainForm.createGridPanel;
    vimmMainForm.setInitialGridValues;
    vimmMainForm.canSaveData := saveData;
    if vimmMainForm.ShowModal = mrOK then
      begin
        result := true;
        if not vimmMainForm.canSaveData then
          begin
            getVimmResultList(resultList);
            getBillingCodes(vimmMainForm.encDate);
          end
        else if vimmMainForm.noteString <> '' then resultList.Add(vimmMainForm.noteString);
      end;
  finally
     FreeAndNil(vimmMainForm);
  end;

end;

procedure TvimmMainForm.btnSaveClick(Sender: TObject);
var
aControl: TControl;
valid: boolean;
activeList, historicalList, noteList, PCEList: TStringList;
noteResult, vStr: String;

  procedure BuildCurrentData(activeList: TStringList; encDate: TFMDateTime; encLoc, encType, encProv, patient, vStr: String; var PCEList: TStringList);
    begin
      buildCurrentPCEList(activeList, encDate, encLoc, encType, encProv, patient, vStr, pcelist);
    end;

  procedure BuildHistoricalData(historicalList: TStringList; encProv, patient: String; var PCEList);
    begin
      saveHistoricalData(historicalList, encProv, patient);
    end;

begin
  activeList := TStringList.Create;
  historicalList := TStringList.Create;
  noteList := TStringList.Create;
  PCEList := TStringList.Create;
  try
  aControl := self.GridPanel.ControlCollection.Controls[0, self.GridPanel.RowCollection.Count - 1];
  if self.noGrid then
    begin
      if not TfraImmEdit(aControl).valiateFromParent then exit;
    end;
  valid := true;
  //canSaveData is true if called from CPRS coversheet or external application
  if CanSaveData then
    valid := saveData(self.encDate, self.encLoc, self.encType, self.encProvIEN + U + self.encProvName, self.patientIEN,
                      self.userIEN, activeList, historicalList, noteList);
  if not valid then
    begin
      infoBox('Cannot save with an incomplete record', 'Error', MB_OK);
      exit;
    end;
  vStr := encLoc + ';' + FloatToStr(encDate) + ';' + encType;
  if noteList.Count > 0 then
    begin
      noteResult := saveNoteText(noteList, encDate, encLoc, encType, vStr, patientIEN, userIEN);
      if Piece(noteResult, U, 1)= '0' then
        begin
          infoBox(Piece(noteResult, U, 2), 'Could not save note', MB_OK);
        end
      else self.noteString := noteResult;
    end;
  if activeList.Count > 0 then
    begin
      BuildCurrentData(activeList, encDate, encLoc, encType, self.encProvIEN + U + self.encProvName, patientIEN, vStr, PCEList);
      if PCEList.Count > 0 then SavePCEData(PCEList, 0, StrToInt(encLoc));
    end;
  if historicalList.Count > 0 then
    begin
      if PCEList.Count > 0 then PCEList.Clear;
      BuildHistoricalData(historicalList, self.encProvIEN + U + self.encProvName, patientIEN, PCEList);
    end;
  if canSaveData then clearResults;

  modalResult := mrOK;
  finally
  FreeAndNil(activeList);
  FreeAndNil(historicalList);
  FreeAndNil(noteList);
  FreeAndNil(PCEList);
  end;

end;

procedure TvimmMainForm.btnCancelClick(Sender: TObject);
begin
  modalResult := mrCancel;
  if canSaveData then clearResults;

  self.Release;
end;



procedure TvimmMainForm.createGridPanel;
var
aRow, aCol: integer;

  procedure PlaceFrame(aGridPanel: TGridPanel; aControl: TControl; aCol, aRow: integer; aAlign: TAlign);
    begin
      aControl.Parent := aGridPanel;
      aGridPanel.ControlCollection.AddControl(aControl, aCol, aRow);
      aControl.Align := aAlign;
      aGridPanel.RowCollection[aRow].SizeStyle := TFraParent(aControl).style;
      aGridPanel.RowCollection[aRow].Value := TFraParent(aControl).minValue;
    end;

begin
  try
    if not application.Terminated then
      begin
        gridPanel.RowCollection.BeginUpdate;
        if noGrid then
          begin
            if gridPanel.RowCollection.Count > 3 then gridPanel.RowCollection[3].Destroy;
          end
        else if gridPanel.RowCollection.Count = 3 then
          begin
            gridPanel.RowCollection.Add
          end;
        aCol := 0;
        aRow := 0;
        frmICE := TfraIce.create(gridPanel);
        placeFrame(gridPanel, frmICE, aCol, aRow, alClient);
        //noGrid is true if called from Reminders with a specific immunization or from external application
        if noGrid = false then
          begin
            inc(ARow);
            frmGrid := TfraGrid.Create(gridPanel);
            placeFrame(gridPanel, frmGrid, aCol, aRow, alClient);
          end;
        inc(aRow);
        frmImm := TfraImm.Create(gridPanel);
        placeFrame(gridPanel, frmImm, aCol, aRow, alClient);
        TFraImm(frmImm).setEncounterData(self.encDate, self.patientIEN);
        frmImmEdit := TfraImmEdit.Create(gridPanel);
        inc(aRow);
        placeFrame(gridPanel, frmImmEdit, aCol, aRow, alClient);
        TfraImmEdit(frmImmEdit).setEncounterData(self.encDate, self.encProvName, self.encProvIEN, self.userName, self.userIEN, self.encLoc, self.visitString);
        if self.noGrid = true then
          begin
            TfraImmEdit(frmImmEdit).btnOk.Caption := 'Save and Exit';
            disableButtons;
          end;
        gridPanel.RowCollection.EndUpdate;
      end;
  finally
  end;
end;

//disable edit frame buttons if the application is updating one item only.
//reminders with spedific finding or external application
procedure TvimmMainForm.disableButtons;
var
aControl: TControl;
begin
   aControl := self.GridPanel.ControlCollection.Controls[0, self.GridPanel.RowCollection.Count - 1];
   TfraImmEdit(aControl).btnOk.Enabled := false;
   TfraImmEdit(aControl).btnCancel.Enabled := false;
   TfraImmEdit(aControl).pnlBottom.Visible := false;
end;

procedure TvimmMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  try
    SaveUserBounds(Self);
    Action := caFree;
  finally
    Action := caFree;
  end;
end;

procedure TvimmMainForm.FormCreate(Sender: TObject);
begin
  inherited;
  SetFormPosition(Self);
  ResizeFormToFont(self);
end;

procedure TvimmMainForm.setInitialGridValues;
var
aControl: TControl;
immunization: string;
edit: boolean;
data: TVimmResult;

begin
 //ice collapse determine by calling application
  if self.collapseICE = true then
    begin
      aControl := gridPanel.ControlCollection.Controls[0, 0];
      TfraIce(aControl).collapse;
    end;
  //noGrid determine by calling application
  if self.noGrid = true then
    begin
      aControl := gridPanel.ControlCollection.Controls[0, 1];
      TfraImm(aControl).expand;
      if initialList.Count = 1 then
        begin
          immunization := initialList.Strings[0];
          if StrToInt(Piece(immunization, U, 3)) > -1 then
            begin
              edit := true;
              data := TVimmResult(initialList.Objects[0]);
              if data.documType = 'Administered' then self.documentType := '0'
              else if data.documType = 'Historical' then self.documentType := '1'
              else if data.documType = 'Contraindication' then self.documentType := '2'
              else if data.documType = 'Refused' then self.documentType := '3';
              immunization := Piece(immunization, U, 3) + U + data.name + U + self.documentType;
            end
          else
            begin
              edit := false;
              immunization := getVImmIds(immunization, false) + U + self.documentType;
            end;
          if immunization = '' then
            begin
              ShowMessage('Cannot find immunization entry');
              exit;
            end;
          if TFraImm(aControl).startEditsFromMain(immunization, edit) = false then self.Close;
        end;
    end
  else
    begin
      aControl := gridPanel.ControlCollection.Controls[0,2];
      TFraImm(aControl).collapse;
      aControl := gridPanel.ControlCollection.Controls[0,3];
      TfraImmEdit(aControl).collapse;
      aControl := gridPanel.ControlCollection.Controls[0,1];
      TfraGrid(aControl).expand;
      if initialList <> nil then TFraGrid(aControl).addListToGrid(initialList, documentType);
    end;

end;

function TvimmMainForm.validateInput(inputList: TStringList): boolean;
var
i, idx: integer;
name,tmp, text, value: string;
tmpList: TStringList;
data: TVimmResult;
begin
  tmpList := TStringList.Create;
  try
  result := true;
  for i := 0 to inputList.Count - 1 do
    begin
       tmp := inputList.Strings[i];
       if tmp = 'vimmList' then continue;
       name := Piece(tmp, U, 1);
       value := Piece(tmp, U, 2);
       //verify name value pairs
       if value = '' then
        begin
          infoBox('Missing Data Input for property: ' + name, 'Error', MB_OK);
          result := false;
          exit;
        end;
       if name = 'userName' then self.userName := value
       else if name = 'userIEN' then self.userIEN := value
       else if name = 'encounterProviderName' then self.encProvName := value
       else if name = 'encounterProviderIEN' then self.encProvIEN := value
       else if name = 'encounterLocation' then self.encLoc := value
       else if name = 'encounterCategory' then self.encType := value
       else if name = 'dateEncounterDateTime' then self.encDate := StrToFloat(value)
       else if name = 'visitString' then self.visitString := value
       else if name = 'noGrid' then self.noGrid := value = '1'
       else if name = 'patientName' then self.patientName := value
       else if name = 'patientIEN' then self.patientIEN := value
       else if name = 'collapseICE' then self.collapseICE := value = '1'
       else if name = 'makeNote' then self.makeNote := value = '1'
       else if name = 'documentType' then self.documentType := value
       else if pos('VIMM', name)>0 then
        begin
          if initialList = nil then initialList := TStringList.Create;
          initialList.Add(Pieces(tmp, u, 2, 3) + U + '-1');
        end
       else if pos('DATA', name)>0 then
        begin
           data := TVimmResult(inputList.Objects[i]);
           if initialList = nil then initialList := TStringList.Create;
           idx := setVimmResults(data);
           if idx = -1 then ShowMessage('Problem adding previous results to the form');
           initialList.AddObject(data.id + U + data.name + U + IntToStr(idx), data);
        end
        else if Pos('EDIT', name) > 0 then
        begin
          if initialList = nil then initialList := TStringList.Create;
          data := TVimmResult.create;
          data.setfromDelimitedStr(value, self.encType);
           idx := setVimmResults(data);
           if idx = -1 then ShowMessage('Problem adding previous results to the form');
           initialList.AddObject(data.id + U + data.name + U + IntToStr(idx), data);
//          initialList.Add(Pieces(tmp, u, 2, 3) + U + '-1');
        end;


    end;
    text := 'The following value(s) are missing:' + CRLF;
    if self.VsID          then
      begin
         text := text + CRLF + 'User Name';
         result := false;
      end;
    if self.userIEN = '' then
      begin
         text := text + CRLF + 'User IEN';
         result := false;
      end;
    if self.encProvName = '' then
      begin
         text := text + CRLF + 'Encounter Provider Name';
         result := false;
      end;
    if self.encProvIEN = '' then
      begin
         text := text + CRLF + 'Encounter Provider IEN';
         result := false;
      end;
    if self.encLoc = '' then
      begin
         text := text + CRLF + 'Encounter Location';
         result := false;
      end;
    if self.encType = '' then
      begin
         text := text + CRLF + 'Encounter Type';
         result := false;
      end;
    if self.encDate < 1 then
      begin
         text := text + CRLF + 'Encounter Date';
         result := false;
      end;
    if self.visitString = '' then
      begin
         text := text + CRLF + 'Visit String';
         result := false;
      end;
    text := text + CRLF + CRLF + 'Cannot Enter Immunization/Skin Test Data at this time.';
    if not result then infoBox(text, 'Error', MB_OK);
  finally
    tmpList.Free;
  end;
end;

end.
